#ifndef IAGENT_H_
#define IAGENT_H_
#include <string>
#include "../DataTypes/DataAgent.h"

using namespace std;
using namespace DataTypes;
namespace Communication
{

class IAgent
{
public:
	IAgent();
	virtual ~IAgent();
	virtual int GetPort()=0;
	virtual string GetIP()=0;
	virtual bool GetSyncMode()=0;
	virtual bool GetSyncFlag()=0;
	virtual int GetIterationSync()=0;
	virtual string GetKey()=0;
	virtual double GetTimeStamp()=0;
	virtual double GetBroadcastInterval()=0;
	virtual void SetTimeStamp(double value)=0;
	virtual void SetSyncFlag(bool value)=0;
	virtual void SetIterationSync(int value)=0;
	virtual string FilterData(string data)=0;
	virtual DataAgent* GetDataAgent() = 0;
};

}

#endif /*IAGENT_H_*/
